//  Created by Pieter Omvlee on 24/11/2010.
//  Copyright 2010 Bohemian Coding. All rights reserved.

#import <GlyphsKit/BCCollectionViewDelegate.h>
#import <Cocoa/Cocoa.h>

#ifndef BCArray
#define BCArray(args...) [NSArray arrayWithObjects:args, nil]
#endif

@class BCCollectionViewLayoutManager;

@interface BCCollectionView : NSView {
	id<BCCollectionViewDelegate> __unsafe_unretained _theDelegate;
	BCCollectionViewLayoutManager *_layoutManager;

	NSArray *_contentArray;
	NSArray *_groups;

	NSMutableArray *_reusableViewControllers;
	NSMutableDictionary<NSNumber *, NSViewController *> *_visibleViewControllers;
	NSMutableIndexSet *_selectionIndexes;
	NSMutableDictionary *_visibleGroupViewControllers;

	NSColor *_backgroundColor;
	NSUInteger _numberOfPreRenderedRows;
	NSUInteger _border;

	NSPoint _mouseDownLocation;
	NSPoint _mouseDraggedLocation;
	NSInteger _dragHoverIndex;
	BOOL _selectionChangedDisabled;
	NSUInteger _lastSelectionIndex;
	BOOL _animated;
	BOOL _firstDrag;
	BOOL _isDragging;
	BOOL _hasRangeSelection;
	NSRect _cachedSize;
	NSRect _newFrame;
}

@property (nonatomic, unsafe_unretained) IBOutlet id<BCCollectionViewDelegate> delegate;
@property (nonatomic, strong) NSColor *backgroundColor;
@property (nonatomic) NSUInteger numberOfPreRenderedRows;
@property (nonatomic, assign) NSUInteger border;
//private
@property (nonatomic, copy) NSIndexSet *originalSelectionIndexes;
@property (nonatomic, copy) NSArray *contentArray, *groups;
@property (nonatomic, copy) NSString *zoomValueObserverKey, *accumulatedKeyStrokes;

@property (unsafe_unretained, readonly) NSArray *visibleViewControllerArray;
@property (readonly) NSMutableDictionary *visibleGroupViewControllers;
@property (readonly) BCCollectionViewLayoutManager *layoutManager;
@property (nonatomic, strong) NSArray *activeSelection;

@property (nonatomic, strong) NSTimer *doubleClickTimer;

- (void)scrollViewDidScroll:(NSNotification *)note;
//designated way to load BCCollectionView
- (void)reloadDataWithItems:(NSArray *)newContent emptyCaches:(BOOL)shouldEmptyCaches;
- (void)reloadDataWithItems:(NSArray *)newContent groups:(NSArray *)newGroups emptyCaches:(BOOL)shouldEmptyCaches;
- (void)reloadDataWithItems:(NSArray *)newContent groups:(NSArray *)newGroups emptyCaches:(BOOL)shouldEmptyCaches completionBlock:(dispatch_block_t)completionBlock;

//Managing Selections
- (void)selectItemAtIndex:(NSUInteger)idx;
- (void)selectItemAtIndex:(NSUInteger)idx inBulk:(BOOL)bulk;

- (void)selectItemsAtIndexes:(NSIndexSet *)indexes;
#if 0
- (void)deselectItemAtIndex:(NSUInteger)idx;
#endif
- (void)deselectItemsAtIndexes:(NSIndexSet *)indexes;

- (void)deselectAllItems;
- (NSIndexSet *)selectionIndexes;
- (void)_delegateCollectionViewSelectionDidChange;
- (void)delegateDidSelectItemsAtIndexes:(NSIndexSet *)indexSet oldSelection:(NSIndexSet *)oldSelction;
//Basic Cell Information
- (void)forceUpdate;
- (void)reflow;
- (NSSize)cellSize;
- (NSUInteger)groupHeaderHeight;
- (NSRange)rangeOfVisibleItems;
- (NSRange)rangeOfVisibleItemsWithOverflow;

- (NSIndexSet *)indexesOfItemsInRect:(NSRect)rect;
- (NSIndexSet *)indexesOfItemContentRectsInRect:(NSRect)rect;
- (NSRect)rectForItemAtIndex:(NSUInteger)idx;
//Querying ViewControllers
- (NSIndexSet *)indexesOfViewControllers;
- (NSIndexSet *)indexesOfInvisibleViewControllers;
- (NSViewController *)viewControllerForItemAtIndex:(NSUInteger)idx;

- (void)softReloadDataWithCompletionBlock:(dispatch_block_t)block;
- (void)viewDidResize;

- (void)scrollItemAtIndexToVisible:(NSUInteger)idx;
@end
